
#define database_create
/*  DATABASE_CREATE
  GM Database Suppport v3.x by Alasdair Forsythe
  Create database file.
             argument0 is the path of the database file.
             argument1 is the number of tables.
             argument2 is the number of columns.
             argument3 is the number of rows.
             argument4 if encrypted (1=encrypted, 0=not encrypted).
*/

var temp,runthru,tempb
{
filewq=file_text_open_write(argument0);
file_text_write_real(filewq,argument4); file_text_writeln(filewq);
if argument4 file_text_write_string(filewq,encryption(string(argument1),1)) else file_text_write_string(filewq,string(argument1)); file_text_writeln(filewq);

temp='{1}'
for (runthru=1; runthru<=argument1; runthru+=1)
temp+='Table ' + string(runthru) + '{' + string(runthru+1) + '}'
if argument4 file_text_write_string(filewq,encryption(temp,1)) else file_text_write_string(filewq,temp); file_text_writeln(filewq);

repeat(argument1)
{
if argument4 file_text_write_string(filewq,encryption(string(argument2) + ',' + string(argument3),1)) else file_text_write_string(filewq,string(argument2) + ',' + string(argument3)); file_text_writeln(filewq);

if argument2>0 && argument3>0
   {
   temp='{1}'
   for (runthru=1; runthru<=argument2; runthru+=1)
   temp+='Column ' + string(runthru) + '{' + string(runthru+1) + '}'
   if argument4 file_text_write_string(filewq,encryption(temp,1)) else file_text_write_string(filewq,temp); file_text_writeln(filewq);
   
   temp='{1}'
   for (runthru=1; runthru<=argument3; runthru+=1)
   temp+='Row ' + string(runthru) + '{' + string(runthru+1) + '}'
   if argument4 file_text_write_string(filewq,encryption(temp,1)) else file_text_write_string(filewq,temp); file_text_writeln(filewq);
   
   for (tempb=1; tempb<=argument3; tempb+=1)
       {
       temp='{1}'
       for (runthru=1; runthru<=argument2; runthru+=1)
       temp+=string(runthru) + ',' + string(tempb) + '{' + string(runthru+1) + '}'
       if argument4 file_text_write_string(filewq,encryption(temp,1)) else file_text_write_string(filewq,temp); file_text_writeln(filewq);
       }
   }
}
file_text_close(filewq)
}

#define convert_direct
/*  CONVERT_DIRECT
  GM Database Suppport v3.x by Alasdair Forsythe
  Convert a database between encryption and decryption.
             argument0 is the path of the database file.
             argument1 if to encrypt it (1=encrypt, 0=decrypt).
  -1 is returned if an error occurs
*/

var runthru,line,read
{
if file_exists(argument0) fileoq=file_text_open_read(argument0) else return -1
for (line=0; !file_text_eof(fileoq); {line+=1; file_text_readln(fileoq)})
read[line]=file_text_read_string(fileoq)
file_text_close(fileoq)

filewq=file_text_open_write(argument0)
file_text_write_real(filewq,argument1); file_text_writeln(filewq)

for (runthru=1; runthru<line; if runthru<line {runthru+=1; file_text_writeln(filewq);})
{
file_text_write_string(filewq,encryption(read[runthru],argument1))
}
file_text_close(filewq)
}
